cls
clear

**set the folder directory to your computer settings
global folder "Your_folder\Stata_package_for_JMCB"  
cd $folder

** datasets and controls
global data_PTH "data_RR_PTH_public"
global data_to_be_used "data_RR_MASTER_public"
global data_to_be_used_matching "data_matching"
global controls 			   L_cet1_buffer L_lr_buffer L_NPL_ratio L_CSH_to_A L_DEP_to_L L_density L_TLAC
global controls_quart 		   L_cet1_buffer L_lr_buffer L_NPL_ratio L_CSH_to_A L_DEP_to_L L_density L_TLAC 
global mtch_prd    				 cet1_buffer   lr_buffer   NPL_ratio   CSH_to_A   DEP_to_L   density   TLAC  ROA

********************************************************************************
** Table D.1: Correlation of banks' ROA from one year to the next
********************************************************************************
cls
clear
use "$folder\\$data_to_be_used", replace
*collapse (mean) ROA ROA_med_year, by(id year)
*reshape wide ROA ROA_med_year, i(id) j(year)
collapse (mean) ROA, by(id year)
reshape wide ROA, i(id) j(year)
pwcorr ROA*, sig
spearman ROA*

********************************************************************************
** Figure D.1: Average ROA across groups over time
********************************************************************************
use "$folder\\$data_to_be_used", replace
keep if always_mpg == 1
keep id year bank_type ROA post_2015
drop if bank_type == ""

collapse (mean) ROA, by(bank_type year)
sort bank_type year

twoway ///
line ROA year if bank_type == "Low ROA Non GSIB", xline(2015, lpattern(dash) lcolor(red)) yaxis(1) lcolor(cyan) yscale(range(0 2.0) axis(1)) ylabel(0 0.5 1.0 1.5 2.0, axis(1)) ytitle("", axis(1)) || ///
line ROA  year if bank_type == "High ROA Non GSIB", yaxis(1) lpattern(dash) lcolor(navy) yscale(range(0 2.0) axis(1)) ylabel(0 0.5 1.0 1.5 2.0, axis(1)) ytitle("", axis(1)) || ///
line ROA  year if bank_type == "High ROA GSIB", lcolor(cranberry) lpattern(dot) yaxis(1) yscale(range(0 2.0) axis(1)) ylabel(0 0.5 1.0 1.5 2.0, axis(1)) ytitle("", axis(1)) || ///
line ROA  year if bank_type == "Low ROA GSIB", lcolor(sand) lpattern(dash_dot) yaxis(1) yscale(range(0 2.0) axis(1)) ylabel(0 0.5 1.0 1.5 2.0, axis(1)) ytitle("", axis(1))  ///
legend(order(2 "High ROA Non G-SIBs"  1 "Low ROA Non G-SIBs" 3 "High ROA G-SIBs" 4 "Low ROA G-SIBs" ) symxsize(*1) rows(2) pos(6) colgap(20) region(lcolor(white)) size(4)) ///
graphregion(color(white)) name(line_ROA_evolve, replace) ysize(3) xsize(4) xtitle("") ytitle(Average ROA: Non G-SIBs, height(8) axis(1) size(4)) ///
ytitle(Average ROA, height(10) axis(1) size(4)) ///
text(1.0  2014 "Pre-treatment", color(black) size(4)) ///
text(0.75 2014 "period", color(black) size(4)) 
graph export "$folder\exhibits\OnlineAppendix_Fig_D1_ROA_by_group.jpg",  replace
graph export "$folder\exhibits\OnlineAppendix_Fig_D1_ROA_by_group.pdf",  replace


********************************************************************************
** Table E.1: Summary statistics of additional variables
********************************************************************************
use "$folder\\$data_to_be_used", replace
estpost tabstat ROE RORWA RAROA Z_score C2I BETA_w50, ///
statistics(mean sd p10 p25 p50 p75 p90 count) columns(statistics)
esttab . using "$folder\exhibits\OnlineAppendix_Tab_E1_extra_sum_stat", tex ///
cell((mean(fmt(2)) sd(fmt(2)) p10(fmt(2)) p25(fmt(2)) p50(fmt(2)) p75(fmt(2)) p90(fmt(2)) count(fmt(0)))) ///
collabels("Mean" "Stdev" "P10" "P25" "P50" "P75" "P90" "N") ///
replace label nonumber noobs

**************************************************************************************
** Table E.2: Alternative profitability and efficiency metrics
**************************************************************************************
cls
clear
use "$folder\\$data_to_be_used", replace
eststo clear
global output_filename "$folder\exhibits\OnlineAppendix_Tab_E2_alf_prof"

replace dummy = ROA_continuous_2014
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

preserve
use "$folder\\$data_to_be_used", replace
merge m:1 id using "$folder\data_ROA_from_2010_public"
drop if _merge == 2
drop _merge
replace dummy = avg_ROA_2010_to_2014 
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes
restore

replace dummy = pre_ROE_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

replace dummy = pre_eff_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

replace dummy = pre_RORWA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

replace dummy = pre_RAROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

replace dummy = pre_Z_score_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels drop(_cons $controls) ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib  1.post#c.dummy) star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_fe ct_fe , labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" )) ///
nomtitles mgroups("\shortstack{ROA \\(2014)}" "\shortstack{ROA \\(2010-2014)}" "\shortstack{Return on \\equity}" "\shortstack{Cost-to-income \\efficiency}" "\shortstack{Return on\\ RWA}" "\shortstack{Risk-adjusted\\ ROA}" "Z-score", pattern(1 1 1 1 1 1 1 ) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)

********************************************************************************
** Table E.3: Alternative specifications and sample composition
********************************************************************************
cls
clear

use "$folder\\$data_to_be_used", replace
eststo clear
global output_filename "$folder\exhibits\OnlineAppendix_Tab_E3"
replace dummy = pre_ROA_continuous

*balanced sample
bys id: gen check = (gsib_score!=.)
bys id: replace check = sum(check)
bys id: replace check = check[_N]
egen check_years = max(check)
keep if check==check_years

eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local Dependent Adjusted
estadd local Post 2015
estadd local GSIB Baseline
estadd local Comment Balanced sample

use "$folder\\$data_to_be_used", replace
replace dummy = pre_ROA_continuous

*GSIBs as designated
replace gsib = gsibdesig
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local Dependent Adjusted
estadd local Post 2015
estadd local GSIB Official


use "$folder\\$data_to_be_used", replace
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls BETA_w50, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local Dependent Adjusted
estadd local Post 2015
estadd local GSIB Baseline
estadd local Comment 50week beta


esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels drop(1.gsib#c.dummy 1.gsib  _cons $controls BETA_w50) ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib  1.post#c.dummy) star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_fe ct_fe Dependent Post GSIB Comment, labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE" "G-SIB score" "Post dummy" "G-SIB dummy" "%Notes")) ///
nomtitles mgroups("\shortstack{Balanced \\sample}" "\shortstack{G-SIB as \\designated}" "\shortstack{Control for \\CAPM beta}" , pattern(1 1 1 ) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)

********************************************************************************
** Table E.4: Table: Summary statistics by business model clusters
********************************************************************************
cls 
clear
use "$folder\\$data_to_be_used", replace
eststo clear

** --------------- Step 1: Choose the input variables
bysort id year: gen loans_to_assets = LNS/A if !missing(LNS)  & !missing(A)
bysort id year: gen cash_to_assets = CSH/A if !missing(CSH)  & !missing(A)
bysort id year: gen sec_to_assets = SEC/A if !missing(SEC)  & !missing(A)
bysort id year: gen dep_to_assets = (DEP_to_L*L)/(100*A) if !missing(DEP_to_L)  & !missing(A) & !missing(L)
bysort id year: gen wholesale_to_assets = WL/A if !missing(WL)  & !missing(A) 
bysort id year: gen nonint_to_assets = NI/A if !missing(NI) & !missing(A)

summarize loans_to_assets cash_to_assets sec_to_assets dep_to_assets wholesale_to_assets nonint_to_assets 
// in ratio 
summarize density NPL_ratio C2I
// in pc

** --------------- Step 2: We will use hierarchical agglomerative cluster analysis, similar to Tarashev et al 2014
** using Ward's linkage method, we will use the following 

cluster wardslinkage loans_to_assets sec_to_assets cash_to_assets dep_to_assets wholesale_to_assets nonint_to_assets, measure(L2squared) name(trialA)
cluster dend trialA, cutnumber(4) showc // Adding or removing non int income does not change the distribution

** --------------- Step 3: Cut into clusters and create summary statistics tables
global list1 loans_to_assets sec_to_assets cash_to_assets dep_to_assets wholesale_to_assets nonint_to_assets  

** Natural to start with 4 clusters (Eg. Tarashev et al)
cluster generate gp_trialA = groups(4), name(trialA) // manually fix the no. of clusters at 4
eststo trialA_c4: qui estpost tabstat $list1, by(gp_trialA) stat(mean p10 p90 N) nototal

global output_filename "$folder\exhibits\OnlineAppendix_Tab_E4_buss_model_sum_stat"
esttab trialA_c4 using $output_filename, tex cells("loans_to_assets(fmt(2)) sec_to_assets(fmt(2)) cash_to_assets(fmt(2)) dep_to_assets(fmt(2)) wholesale_to_assets(fmt(2)) nonint_to_assets(fmt(2))") plain nonumber nogaps lines nolabel replace 

** Robustness: 3 clusters? Looks like it merges groups (3) and (4) but keeps groups (1) and (2) as is
cluster generate gp_trialA_alt1 = groups(3), name(trialA) 
eststo trialA_c3: qui estpost tabstat $list1, by(gp_trialA_alt1) stat(mean p25 p75 N) nototal

** Robustness: 2 clusters? Looks like it merges groups (1) and (2) and (3) and (4)
cluster generate gp_trialA_alt2 = groups(2), name(trialA) 
eststo trialA_c2: qui estpost tabstat $list1, by(gp_trialA_alt2) stat(mean p10 p90 N) nototal

** --------------- Step 4: Now do visual inspection using a scatterplot
/*
global list2 wholesale_to_assets loans_to_assets
foreach v of varlist gp_trial* {
graph twoway (scatter $list2 if `v'==1, msymbol(Oh) msize(small)) ///
  (scatter $list2 if `v'==2, msymbol(Sh) msize(small)) ///
  (scatter $list2 if `v'==3, msymbol(Dh) msize(small)) ///
  (scatter $list2 if `v'==4, msymbol(Th) msize(small)), ///
  legend(label(1 group1) label(2 group2) label(3 group3) label(4 group4)) 
graph export "$folder\exhibits\cluster_`v'.png", as(png) replace
}
*/

** --------------- Step 5: Finally, run regs w/ business model as additional variable, plus bank controls (see Table E.5)

********************************************************************************
** Table E.5: Controlling for differences in business models
********************************************************************************

eststo clear
replace dummy = pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.gp_trialA $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local cls Bank-level
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local catype 4 

eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.gp_trialA_alt1 $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local cls Bank-level
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local catype 3 

eststo: reghdfe gsib_score i.post##i.gsib##c.dummy i.gp_trialA_alt2 $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local cls Bank-level
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local catype 2 

global output_filename "$folder\exhibits\OnlineAppendix_Tab_E5_buss_model"
esttab using $output_filename, tex label nogaps lines nonotes replace noconstant noomitted nobaselevels ///
order(1.post#1.gsib#c.dummy 1.post#1.gsib  1.post#c.dummy) ///
drop($controls 2.gp_trialA 3.gp_trialA 4.gp_trialA 2.gp_trialA_alt1 3.gp_trialA_alt1 2.gp_trialA_alt2 _cons) ///
star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_fe ct_fe catype, labels("N" "Adj. R2" "Lagged bank controls and FE" "Country-time FE" "No. of business model clusters" )) ///
nomtitles mgroups("Business models" , pattern(1 0 0 0 0 0) /// 
prefix(\multicolumn{@span}{c}{) suffix(}) span)

********************************************************************************
** Table E.6: Geographical factors
********************************************************************************
cls
clear
use "$folder\\$data_to_be_used", replace
eststo clear

**Exclude US banks
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls if !inlist(cc,"US"), absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes


**EMEs only
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.gsib##c.dummy $controls if EME==1, absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes


**Replace GSIB with a Regional Group dummy
use "$folder\\$data_to_be_used", replace

replace EU = 0 if cc=="CH" | cc=="NO"

**US dummy
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.US##c.dummy $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes


**EU dummy
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.EU##c.dummy $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes


**ASIA-PACIFIC dummy
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.ASIA_PAC##c.dummy $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes


**EME dummy
replace dummy =  pre_ROA_continuous
eststo: reghdfe gsib_score i.post##i.EME##c.dummy $controls , absorb(i.id i.year#i.cc_num) vce(cluster id) 
estadd local bank_fe Yes
estadd local ct_fe Yes

global output_filename "$folder\exhibits\OnlineAppendix_Tab_E6_geo"
esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels drop(_cons $controls) ///
order(1.post#1.gsib#c.dummy 1.post#1.US#c.dummy 1.post#1.EU#c.dummy 1.post#1.ASIA_PAC#c.dummy 1.post#1.EME#c.dummy 1.post#1.gsib 1.post#c.dummy) star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a bank_fe ct_fe, labels("N" "Adj. R2" "Bank controls and FE" "Country-time FE")) ///
nomtitles mgroups("\shortstack{Exclude \\U.S. banks}" "\shortstack{Only \\EME}"  "\shortstack{U.S. \\dummy}" "\shortstack{EU \\dummy}" "\shortstack{Asia-Pac \\dummy}" "\shortstack{EME \\dummy}", pattern(1 1 1 1 1 1) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)

********************************************************************************
** Table F.1 Summary statistics
********************************************************************************

use "$folder\\$data_PTH", replace
eststo clear
keep if year >= 2010 & year <= 2019
gen main = pre_ROA_continuous
label variable main Profitability
replace ln_C = ln(C/1000)
replace ln_A = ln(A/1000)
label variable ln_A Assets
label variable ln_C Capital
label variable CET1_ratio "CET1 Capital ratio"
gen Tot_cap_ratio = C_2013/A_2013 * 100
label variable Tot_cap_ratio "Total Capital ratio"

replace L_density = L_density * 100
replace density = density * 100

keep if gsib_forever == 1
** set controls and make the sample consistent
reghdfe ln_C i.post##c.main $controls_quart, absorb(i.id i.qdate#i.cc_num) vce(cluster id) 
gen smpl = e(sample)
keep if smpl == 1


preserve
label variable ln_C "Capital (log)"
label variable ln_A "Assets (log)"
label variable L_ROA "Return on assets (\%)"
label variable L_cet1_buffer "CET1 capital ratio buffer (\%)"
label variable L_lr_buffer "Leverage ratio buffer (\%)"
label variable L_TLAC "Total loss absorbing capacity (\%)"
label variable L_NPL_ratio "Non-performing loans ratio (\%)"
label variable L_CSH_to_A "Cash to total assets (\%)"
label variable L_DEP_to_L "Deposit to total liabilities (\%)"
label variable L_density "Density ratio (\%)"
estpost tabstat ln_C ln_A $controls_quart, ///
				statistics(mean sd p10 p25 p50 p75 p90 count) columns(statistics)
esttab . using "$folder\exhibits\OnlineAppendix_Tab_F1_quarter_sum_stat", tex ///
cell((mean(fmt(2)) sd(fmt(2)) p10(fmt(2)) p25(fmt(2)) p50(fmt(2)) p75(fmt(2)) p90(fmt(2)) count(fmt(0)))) ///
collabels("Mean" "Stdev" "P10" "P25" "P50" "P75" "P90" "N") ///
replace label nonumber noobs
restore

************************************************************************************************
** Table F.2: Differential evolution of capital and assets of low and high profitability G-SIBs
************************************************************************************************

eststo: reghdfe ln_C i.post##c.main, absorb(i.id i.qdate#i.cc_num) vce(cluster id) 
estadd local cls Bank
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local mod Continuous
estadd local controls No
		
eststo: reghdfe ln_C i.post##c.main $controls_quart, absorb(i.id i.qdate#i.cc_num) vce(cluster id) 
estadd local cls Bank
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local mod Continuous
estadd local controls Yes

eststo: reghdfe ln_A i.post##c.main, absorb(i.id i.qdate#i.cc_num) vce(cluster id) 
estadd local cls Bank
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local mod Continuous
estadd local controls No

eststo: reghdfe ln_A i.post##c.main $controls_quart, absorb(i.id i.qdate#i.cc_num) vce(cluster id) 
estadd local cls Bank
estadd local bank_fe Yes
estadd local ct_fe Yes
estadd local mod Continuous
estadd local controls Yes

global output_filename "$folder\exhibits\OnlineAppendix_Tab_F2_quarter_reg"
esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels ///
keep(1.post#c.main) ///
order(1.post#1.gsib_forever 1.post#1.gsib_forever#c.pre_ROA_continuous  1.post#1.gsib_forever#1.dummy) star(* 0.10 ** 0.05 *** 0.01) ///
stats(N r2_a cls bank_fe ct_fe mod controls, labels("N" "Adj. R2" "Clustering" "Bank FE" "Country-time FE" "Profitability" "Controls")) 


********************************************************************************
** Table G.1: Summary statistics
********************************************************************************
use "$folder\\$data_to_be_used", replace
estpost tabstat cat_scr_1 cat_scr_2 cat_scr_3 cat_scr_4 cat_scr_5 ///
				ind_scr_v_2_intra_ass ind_scr_v_2_intra_liab ///
				ind_scr_v_2_sec ind_scr_v_3_pay ind_scr_v_3_custody ///
				ind_scr_v_3_underwrite ind_scr_v_4_otc ind_scr_v_4_afs ///
				ind_scr_v_4_level3 ind_scr_v_5_xb_claims ind_scr_v_5_xb_liab, ///
				statistics(mean sd p10 p25 p50 p75 p90 count) columns(statistics)
esttab . using "$folder\exhibits\OnlineAppendix_Tab_G1_ind_sum_stat", tex ///
cell((mean(fmt(2)) sd(fmt(2)) p10(fmt(2)) p25(fmt(2)) p50(fmt(2)) p75(fmt(2)) p90(fmt(2)) count(fmt(0)))) ///
collabels("Mean" "Stdev" "P10" "P25" "P50" "P75" "P90" "N") ///
replace label nonumber noobs

********************************************************************************
** Table G.2: Regressions based on category and indicator scores
********************************************************************************
cls
clear
use "$folder\\$data_to_be_used", replace
eststo clear
replace dummy = pre_ROA_continuous

unab var_list : cat_scr_1 cat_scr_2 cat_scr_3 cat_scr_4 cat_scr_5 ///
				ind_scr_v_2_intra_ass ind_scr_v_2_intra_liab ind_scr_v_2_sec ind_scr_v_3_pay ind_scr_v_3_custody ind_scr_v_3_underwrite ///
				ind_scr_v_4_otc ind_scr_v_4_afs ind_scr_v_4_level3 ind_scr_v_5_xb_claims ind_scr_v_5_xb_liab
di "`var_list'"
global var_list `var_list'

global output_filename "$folder\exhibits\OnlineAppendix_Tab_G2_ind_reg"

foreach x in $var_list {
eststo: reghdfe `x' i.post##i.gsib##c.dummy $controls, absorb(i.id i.year#i.cc_num) vce(cluster id) 
}

esttab using $output_filename, tex label nogaps lines nonotes replace nocons noomitted nobaselevels drop(_cons $controls 1.post#1.gsib 1.post#c.dummy) ///
order(1.post#1.gsib#c.dummy ) star(* 0.10 ** 0.05 *** 0.01) ///
stats(r2_a N, labels("Adj. R2" "N")) ///
nomtitles mgroups("1. Size" "2. Inter-connectedness" "3. Substitutability" "4. Complexity" "5. Cross-jurisdictional activity" ///
"2a. Intra-financial system assets" "2b. Intra-financial system liabilities" "2c. Securitiesoutstanding" "3a. Payments activity" "3b. Assets under custody" "3c. Underwritten transactions" ///
"4a. Notional amount of OTC derivatives" "4b. Trading and AFS securities" "4c. Level 3 assets" "5a. Cross-jurisdictional claims" "5b. Cross-jurisdictional liabilities" ///
, pattern(1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1) ///
prefix(\multicolumn{@span}{c}{) suffix(}) span)
